import UIKit

class DrawView: UIView {
    
    var handlePoint = CGPoint (x: 100, y: 150)
    
    override func draw(_ rect: CGRect) {
        
        let context = UIGraphicsGetCurrentContext()
        context?.setFillColor(UIColor.orange.cgColor)
        context?.fillEllipse(in: CGRect(x: handlePoint.x - 10.0,
                                        y: handlePoint.y - 10.0,
                                        width: 20.0,
                                        height: 20.0))
        
        
        
        
        let startingPoint = CGPoint (x: 100, y: 100)
        let endingPoint = CGPoint (x: 300, y: 300)

        let path = UIBezierPath()
        path.lineWidth = 5.0
        UIColor.black.setStroke()
        
        path.move(to: startingPoint)
        path.addQuadCurve(to: endingPoint,
                          controlPoint: handlePoint)
        path.stroke()
        
        
        let directPath = UIBezierPath()
        directPath.lineWidth = 1.0
        UIColor.green.setStroke()
        directPath.move(to: startingPoint)
        directPath.addLine(to: handlePoint)
        directPath.stroke()

        
        
        
    }
    
    override func touchesMoved(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        handlePoint = (touches.first?.location(in: self))!
        self.setNeedsDisplay()
    }
    
}







class ViewController: UIViewController {
}
